#ifndef CLIENT_H
#define CLIENT_H

#include "package.h"
#include <vector.h>
#include <winsock2.h>
#include <stdlib.h>

class Client
{
    private :
        // numro du client
        int m_iNumClient;
        // indique si le client est prt  dbuter la partie
        bool m_bReady;
        // socket de la connection avec le client
        SOCKET m_Socket;
        // nom du Client
        char * m_szNomJoueur;
        
        // indique si le client a t deconnect au cours de la partie
        bool m_bDisconnected;
    public :
        
        // constructeur par defaut
        Client(int iNumClient, SOCKET Socket);
        
        //
        ~Client();
        
        // cherche les evnements donns par le client sur le rseau
        // et retourne cette liste des vnements
        vector<char>* getEvents();
        
        //retourne le nom du joueur
        char * getNomJoueur(){ return this->m_szNomJoueur; };
        
        // retourne le numero de joueur de l'instance de Client
        int getNumero();
        
        // envoie le package p au client sur le rseau
        void sendPackage(Package *p);
        
        // envoie un buffer au client de taille nbOctets
        void sendBuffer(char * szBuffer, int nbOctets);
        
        // attends que le joueur soit prt
        void waitReady();

        // attends que le client envoi quelque chose sur la connection
        // sert  sychroniser l'envoi des noms
        void wait();

        //recupre le nom du joueur
        void recupNom();

        // envoie un go au client pour lui dire de dmarrer la partie
        void sendGo();
        
        // retourne true si le client est dconnect et false sinon
        bool isDisconnected();
        
};

#endif
